<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>IBSheet7-Product</title>
		<link rel="stylesheet" type="text/css" href="../Sheet/js/css/default/main.css"/>
		<script type="text/javascript" src="../js/common.js"></script>
		<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
		<script type="text/javascript" src="../Chart/ibchart.js"></script>
		<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
		<script type="text/javascript" src="../Sheet/js/ibsheet.js"></script>
		<script type="text/javascript" src="../Sheet/js/locale/ko.js"></script>
		<script type="text/javascript" src="../Sheet/js/plugins/ibsheet-excel.js"></script>
		<script type="text/javascript">
			var pageheightoffset = 310;
			function PageLoad() {
				createIBChart("myChart", "myChart", {
					width: "100%",
					height: "100%"
				});
				initChart();
				init_sheet();
			}
			function init_sheet(){


				var initdata = {};
				initdata.Cfg ={
					Export : {
						Url: "../../product/jsp/"
					}
				};
				initdata.Cols = [
				{Header:"NO","Type":"Int","Name":"SEQ","Width":30,"Align":"Center","Visible":1},
				{Header:"코드","Type":"Text","Name":"CODE","Width":90,"Align":"Center","Visible":1},
				{Header:"펀드 명","Type":"Text","Name":"FUNDNAME","Width":180,"Align":"Left"},
				{Header:"3M","Type":"Float","Name":"3M","Width":48,"Align":"Right"},
				{Header:"6M","Type":"Float","Name":"6M","Width":48,"Align":"Right"},
				{Header:"9M","Type":"Float","Name":"9M","Width":48,"Align":"Right"},
				{Header:"12M","Type":"Float","Name":"12M","Width":48,"Align":"Right"},
				{Header:"18M","Type":"Float","Name":"18M","Width":48,"Align":"Right"},
				{Header:"24M","Type":"Float","Name":"24M","Width":48,"Align":"Right"},
				{Header:"30M","Type":"Float","Name":"30M","Width":48,"Align":"Right"},
				{Header:"36M","Type":"Float","Name":"36M","Width":48,"Align":"Right"},
				{Header:"60M","Type":"Float","Name":"60M","Width":48,"Align":"Right"}
				];
				initdata.Events = {
					onRenderFirstFinish:function(evtParam){
						mySheet.doSearch("sheetData1.jsp");
					},
					onFocus:function(evtParam){
						if(evtParam.orow  && evtParam.orow != evtParam.row){
//							try{
								var pparam = {
									datadirection:"horizontal",
									datarowcol:[evtParam.row],
									legendseriesname:[evtParam.sheet.getValue(evtParam.row,"FUNDNAME")],
									legendtitle:"",
									startdatarowcol:"3M",
									enddatarowcol:"60M",
									labelrowcol:evtParam.sheet.getHeaderRows()[0],
									startlabelrowcol:"3M",
									endlabelrowcol:"60M",
									labeldirection:"horizontal"
								};
								SHEET2CHART(mySheet,myChart,pparam);
//							 } catch(e) {
//							 	alert(e.message);
//							 }
						}
					}
				};
				IBSheet.create({
					id:"mySheet",
					el:"sheetDiv",
					options:initdata
				});
			}

			function getTitle(s,r,c){
				var rows = r.split("|");
				var rtnTitle = "";
				for(var i=0;i<rows.length;i++){
					rtnTitle += s.GetCellText(rows[i],c)+"|";
				}
				return rtnTitle.substring(0,rtnTitle.length-1);
			}

			function initChart() {
				myChart.setOptions({
					chart:{
						type:"pie",
						plotBackgroundColor : "#F7FAFB",
						plotBorderColor:"#A9AEB1",
						plotBorderWidth:0.5,
						backgroundColor:{
							linearGradient : [0,0,100,500],
							stops : [
							[0, "#FFFFFF"],
							[1, "#D3D9E5"]
							]
						},
						borderColor:"#84888B"
					},
					title:{
						text:"IBSheet와 연동",
						style:{
							color:"#15498B",
							fontFamily:"Dotum",
							fontWeight:"bold"
						}
					},
					"plotOptions": {
						"pie": {
							"cursor": "pointer",
							"allowPointSelect":true,
							"showInLegend": true
						}
					},
					tooltip:{
						enabled:true,
						shadow:true,
						formatter:function(){
							return '<span style="color: #4572A7;background-color:#FDFDFD">' +  this.series.name + '</span><br/>' +this.point.name + ' : ' + this.y ;
						},
						style:{
							color:"#000000",
							fontSize:"12px",
							fontWeight:"bold"
						}
					}
				});
			}
			
			
			
		function Down2Excel(){
			/*
			시트의 내용과 차트의 이미지를 동시에 다운로드 한다.	
			엑셀파일에 각 워크시트에 시트, 차트 표현이 가능 하다. (하나의 워크시트에 시트와 차트는 함께 표현이 안됨)
			시트의 ExtendParam에 Svg, ImageWidth, ChartName, ChartPos(0:시트 뒤에 붙임(default), 1:시트앞에 붙임)을 설정하면 엑셀로 다운로드 가능하다.
			ExtendParam
			*/
			var svg = encodeURIComponent(myChart.getSVGString());
			var opt = {
				"fileName":"excel.xls",
				"extendParamMethod":"Post",
				"extendParam":"ChartPos=1&Svg="+svg
			};

			mySheet.down2Excel(opt);
		}

		</script>

	</head>

	<body onload="PageLoad()">

		<div class="page_title">
			<span><a class="closeDepth" href="#">closeDepth</a></span>
			<span class="title color_sheet">시트와 연동  > <b>가로방향 데이터 읽기</b></span>
		</div>

		<div class="main_content">
			<div class="exp_product">
				IB Sheet와 연동기능을 확인합니다.
			</div>
			
			<div class="ib_function float_right">
				<a href="javascript:Down2Excel()" class="f1_btn_white gray">엑셀 다운로드</a>
			</div>
			
			<div class="clear hidden"></div> 

			<div style="width:100%;height:100%">
				<div style="width:48%;height:100%;float:left">
					<p class="subtit_chart">IB Sheet</p>
					<div class="ib_product">
						<div id="sheetDiv" style="width:100%;height:100%"></div>
					</div>
				</div>
				<div style="width:2%;float:left">&nbsp;</div>
				<div  style="width:50%;height:100%;float:left">
					<p class="subtit_chart">IB Chart</p>
					<div class="ib_product">
						<div id="myChart"></div>
					</div>
				</div>
			</div>
			<!--main_content-->
	</body>
</html>








